
#ifndef GL_ES
#   define aPosition	gl_Vertex.xy
#   define aTexcoords0	gl_MultiTexCoord0.xy
#	define aColor		gl_Color
#   define uModelViewProjection gl_ModelViewProjectionMatrix
#	define uTextureMatrix		gl_TextureMatrix[0]

#	define lowp
#	define mediump
#	define highp
#else
	attribute vec2 aPosition;
	attribute mediump vec2 aTexcoords0;
	attribute lowp vec4 aColor;

	uniform mat4 uModelViewProjection;
	uniform mat4 uTextureMatrix;
#endif

varying lowp    vec4 oColor;
varying mediump vec2 oTexcoords;

void main()
{
	oTexcoords = (uTextureMatrix * vec4(aTexcoords0, 0.0, 1.0)).xy;
	oColor = aColor;
	oColor.rgb *= aColor.a;
    gl_Position =  uModelViewProjection * vec4(aPosition, 0.0, 1.0);
}