
#ifndef GL_ES
#define lowp
#define mediump
#define highp
#endif

varying lowp vec4 oColor;
varying mediump vec2 oTexcoords;

uniform lowp sampler2D uTexture0;
uniform lowp vec4 color;

void main()
{
	lowp vec4 textureColor = texture2D(uTexture0, oTexcoords) * oColor;
    gl_FragColor.rgb = mix(textureColor.rgb, color.rgb * textureColor.a, color.a);
	gl_FragColor.a = textureColor.a;
}